<?php
/* --------------------------------------------------------------
 TaxClass.php 2020-01-17
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 17 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Types;

use Gambio\Core\Configuration\Models\Read\Collections\Options;
use Gambio\Core\Configuration\Repositories\Components\OptionsResolver;

/**
 * Class TaxClass
 * @package Gambio\Core\Configuration\Types
 */
class TaxClass implements ConfigurationType
{
    /**
     * @inheritDoc
     */
    public function toOptions(OptionsResolver $resolver, string $value = null): ?Options
    {
        $none = $resolver->getText('TEXT_NONE', 'admin_general');
        
        $connection = $resolver->connection();
        $query      = 'SELECT `tax_class_id` as `value`, `tax_class_title` as `text` FROM `tax_class` ORDER BY `tax_class_title`;';
        
        $data = $connection->fetchAll($query);
        array_unshift($data, ['value' => '0', 'text' => $none]);
        
        return Options::fromArray($data);
    }
    
    
    /**
     * @inheritDoc
     */
    public function inputType(): string
    {
        return 'dropdown';
    }
}